<?php
App::uses('AppController', 'Controller');

class UsersController extends AppController
{
    public $layout = 'member';

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow('members_login', 'members_register', 'members_activate_account', 'members_forgot_password', 'members_new_password', 'members_change_email');
    }
    /*
      public function isAuthorized($user = null)
      {
      // All registered users can add articles
      if ($this->request->action === 'add') {
      return true;
      }

      // The owner of an article can edit and delete it
      if (in_array($this->request->action, array('edit', 'delete' ))) {
      $linkId = (int)$this->request->params['pass'][0];
      return $this->Links->isOwnedBy($linkId, $user['id']);
      }

      return parent::isAuthorized($user);
      }
     */

    public function admin_dashboard()
    {
        $this->layout = 'admin';

        $this->set('website_title', __('Dashboard'));

        $totalLinks = $this->User->Link->find('count', array(
            //'conditions' => array('Link.user_id' => $this->Auth->user('id'))
        ));

        $totalHits = $this->User->Link->Stat->find('count');

        $totalUsers = $this->User->find('count', array(
            'conditions' => array('User.account_type' => 'Free'),
        ));

        $newLinks = $this->User->Link->find('all', array(
            //'conditions' => array('Link.user_id' => $this->Auth->user('id')),
            'recursive' => 0,
            'fields' => array('Link.alias', 'Link.long_url', 'Link.title', 'Link.created', 'Link.clicks', 'User.id', 'User.username'),
            'limit' => 5,
            'order' => array(
                'Link.created' => 'desc'
            )
        ));

        $popularLinks = $this->User->Link->find('all', array(
            //'conditions' => array('Link.user_id' => $this->Auth->user('id')),
            'recursive' => 0,
            'fields' => array('Link.alias', 'Link.long_url', 'Link.title', 'Link.created', 'Link.clicks', 'User.id', 'User.username'),
            'limit' => 5,
            'order' => array(
                'Link.clicks' => 'desc'
            )
        ));

        $newUsers = $this->User->find('all', array(
            'conditions' => array('User.id !=' => 1),
            'recursive' => 0,
            'fields' => array('User.id', 'User.username', 'User.created'),
            'limit' => 10,
            'order' => array(
                'User.created' => 'desc'
            )
        ));


        $popularUsers = Cache::read('popular_users', 'short');
        if (!$popularUsers) {
            $popularUsers = $this->User->find('all', array(
                'joins' => array(
                    array('table' => 'links',
                        'alias' => 'Link',
                        'type' => 'LEFT',
                        'conditions' => array(
                            'User.id = Link.user_id',
                        )
                    )
                ),
                //'recursive' => 0,
                'conditions' => array('User.account_type' => 'Free'),
                'fields' => array('User.id', 'User.username', 'User.created', 'COUNT(Link.user_id) AS total'),
                'limit' => 10,
                'order' => array(
                    'total' => 'desc'
                ),
                'group' => array('User.id'),
            ));
            Cache::write('popular_users', $popularUsers, 'short');
        }

        $linksStats = $this->User->Link->Stat->find('all', array(
            'joins' => array(
                array('table' => 'links',
                    'alias' => 'Link',
                    'type' => 'LEFT',
                    'conditions' => array(
                        'Stat.link_id = Link.id',
                    )
                )
            ),
            'conditions' => array(
                //'Link.user_id' => $this->Auth->user('id'),
                'Stat.created BETWEEN (NOW() - INTERVAL 30 DAY) AND NOW()'
            ),
            // 'COUNT(Stat.referer) AS num'
            'fields' => array('DATE_FORMAT(Stat.created,"%d-%m-%Y") AS statDate', 'COUNT(DATE_FORMAT(Stat.created,"%d-%m-%Y")) AS statDateCount'),
            //'limit' => 100,
            'order' => array(
                'Stat.created' => 'DESC'
            ),
            'group' => array('statDate'),
        ));

        $this->set('totalLinks', $totalLinks);
        $this->set('totalHits', $totalHits);
        $this->set('newLinks', $newLinks);
        $this->set('popularLinks', $popularLinks);
        $this->set('linksStats', $linksStats);
        $this->set('totalUsers', $totalUsers);
        $this->set('newUsers', $newUsers);
        $this->set('popularUsers', $popularUsers);
    }

    public function members_dashboard()
    {
        $this->set('website_title', 'Dashboard');

        $totalLinks = $this->User->Link->find('count', array(
            'conditions' => array('Link.user_id' => $this->Auth->user('id'))
        ));

        $totalHits = $this->User->Link->find('first', array(
            'conditions' => array('Link.user_id' => $this->Auth->user('id')),
            'fields' => array(
                'SUM(Link.clicks) AS total'
            )
        ));

        $newLinks = $this->User->Link->find('all', array(
            'recursive' => 0,
            'fields' => array('Link.alias', 'Link.long_url', 'Link.title', 'Link.created', 'Link.clicks', 'User.id', 'User.username'),
            'conditions' => array('Link.user_id' => $this->Auth->user('id')),
            'limit' => 10,
            'order' => array(
                'Link.created' => 'desc'
            )
        ));

        $popularLinks = $this->User->Link->find('all', array(
            'recursive' => 0,
            'fields' => array('Link.alias', 'Link.long_url', 'Link.title', 'Link.created', 'Link.clicks', 'User.id', 'User.username'),
            'conditions' => array('Link.user_id' => $this->Auth->user('id')),
            'limit' => 10,
            'order' => array(
                'Link.clicks' => 'desc'
            )
        ));

        /*
          $topReferrers = $this->User->Link->Stat->find('all', array(
          'joins' =>  array(
          array('table' => 'links',
          'alias' => 'Link',
          'type' => 'LEFT',
          'conditions' => array(
          'Stat.link_id = Link.id',
          )
          )
          ),
          'conditions' => array('Link.user_id' => $this->Auth->user('id')),
          'fields' => array(
          "SUBSTR(Stat.referer, 1 , IF(LOCATE('/', Stat.referer, 8), LOCATE('/', Stat.referer, 8)-1, LENGTH(Stat.referer)))
          as domain",
          'COUNT(Stat.referer) AS num'
          ),
          'limit' => 10,
          'order' => array(
          'num' => 'desc'
          ),
          'group' => array('domain'),
          ));
         */

        $linksStats = $this->User->Link->Stat->find('all', array(
            'joins' => array(
                array('table' => 'links',
                    'alias' => 'Link',
                    'type' => 'LEFT',
                    'conditions' => array(
                        'Stat.link_id = Link.id',
                    )
                )
            ),
            'conditions' => array(
                'Link.user_id' => $this->Auth->user('id'),
                'Stat.created BETWEEN (NOW() - INTERVAL 30 DAY) AND NOW()'
            ),
            // 'COUNT(Stat.referer) AS num'
            'fields' => array('DATE_FORMAT(Stat.created,"%d-%m-%Y") AS statDate', 'COUNT(DATE_FORMAT(Stat.created,"%d-%m-%Y")) AS statDateCount'),
            //'limit' => 100,
            'order' => array(
                'Stat.created' => 'DESC'
            ),
            'group' => array('statDate'),
        ));

        $this->set('totalLinks', $totalLinks);
        $this->set('totalHits', $totalHits);
        $this->set('newLinks', $newLinks);
        $this->set('popularLinks', $popularLinks);
        $this->set('linksStats', $linksStats);
    }

    public function admin_view($id = null)
    {
        $this->layout = 'admin';

        $this->set('website_title', 'User Details');

        if (!$id) {
            throw new NotFoundException(__('Invalid User.'));
        }

        $user = $this->User->findById($id);

        if (!$user) {
            throw new NotFoundException(__('Invalid User.'));
        }

        $totalLinks = $this->User->Link->find('count', array(
            'conditions' => array('Link.user_id' => $id)
        ));

        $totalHits = $this->User->Stat->find('count', array(
            'conditions' => array('Stat.user_id' => $id)
        ));

        $linksStats = $this->User->Link->Stat->find('all', array(
            'conditions' => array(
                'Stat.user_id' => $id,
                'Stat.created BETWEEN (NOW() - INTERVAL 30 DAY) AND NOW()'
            ),
            // 'COUNT(Stat.referer) AS num'
            'fields' => array('DATE_FORMAT(Stat.created,"%d-%m-%Y") AS statDate', 'COUNT(DATE_FORMAT(Stat.created,"%d-%m-%Y")) AS statDateCount'),
            //'limit' => 100,
            'order' => array(
                'Stat.created' => 'DESC'
            ),
            'group' => array('statDate'),
        ));


        $link_referrers = $this->User->Link->Stat->find('all', array(
            'recursive' => 0,
            'conditions' => array('Link.user_id' => $id),
            'fields' => array(
                "COUNT(Stat.referer) AS num", "Stat.referer_domain"
            ),
            /*
              'fields' => array(
              "COUNT(Stat.referer) AS num", "SUBSTRING_INDEX(REPLACE(REPLACE(Stat.referer,'http://',''),'https://',''),'/',1) AS domain"
              ),
             */
            'order' => array(
                'num' => 'desc'
            ),
            'group' => array('Stat.referer_domain'),
        ));
        $this->set('link_referrers', $link_referrers);



        $this->paginate = array(
            'conditions' => array('Link.user_id' => $id),
            //'fields' => array('Bundle.id', 'Bundle.user_id' , 'Bundle.user_bundle_id', 'Bundle.name', 'Bundle.private', 'Bundle.views', 'Bundle.created', 'Bundle.updated', 'User.id', 'User.username'),
            'limit' => 10,
            'order' => array(
                'Link.created' => 'desc'
            )
        );
        $user_links = $this->paginate('Link');

        $this->set('user', $user);
        $this->set('totalLinks', $totalLinks);
        $this->set('totalHits', $totalHits);
        $this->set('linksStats', $linksStats);
        $this->set('user_links', $user_links);
    }

    public function admin_index()
    {
        $this->layout = 'admin';

        $this->set('website_title', __('Manage All Links'));


        $conditions = array();
        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->data['Filter'])) {
            $filter_url['controller'] = $this->request->params['controller'];
            $filter_url['action'] = $this->request->params['action'];
            // We need to overwrite the page every time we change the parameters
            $filter_url['page'] = 1;

            // for each filter we will add a GET parameter for the generated url
            foreach ($this->data['Filter'] as $name => $value) {
                if ($value) {
                    // You might want to sanitize the $value here
                    // or even do a urlencode to be sure
                    $filter_url[$name] = urlencode($value);
                }
            }
            // now that we have generated an url with GET parameters,
            // we'll redirect to that page
            return $this->redirect($filter_url);
        } else {
            // Inspect all the named parameters to apply the filters
            foreach ($this->params['named'] as $param_name => $value) {
                // Don't apply the default named parameters used for pagination
                if (!in_array($param_name, array('page', 'sort', 'direction', 'limit'))) {
                    // You may use a switch here to make special filters
                    // like "between dates", "greater than", etc

                    $search_params = array('username', 'email');

                    if (in_array($param_name, $search_params)) {
                        $conditions[] = array(
                            array('User.' . $param_name . ' LIKE' => '%' . $value . '%')
                        );

                        //$conditions[] = array('MATCH(User.'.$param_name.') AGAINST(? IN BOOLEAN MODE)' => $value.'*');
                    } else {
                        $conditions['User.' . $param_name] = $value;
                    }
                    $this->request->data['Filter'][$param_name] = $value;
                }
            }
        }


        $this->paginate = array(
            'conditions' => $conditions,
            //'fields' => array('Bundle.id', 'Bundle.user_id' , 'Bundle.user_bundle_id', 'Bundle.name', 'Bundle.private', 'Bundle.views', 'Bundle.created', 'Bundle.updated', 'User.id', 'User.username'),
            'limit' => 10,
            'order' => array(
                'User.created' => 'desc'
            )
        );
        $users = $this->paginate('User');

        $this->set('users', $users);

        // get the possible values for the filters and
        // pass them to the view
        $genres = $this->User->find('list', array(
            'fields' => array('User.username', 'User.first_name')
        ));
        $directors = $this->User->find('list');
        $this->set(compact('genres', 'directors'));

        // Pass the search parameter to highlight the text
        $this->set('search', isset($this->params['named']['search']) ? $this->params['named']['search'] : "");
    }

    public function members_register()
    {
        $this->set('website_title', 'Create an Account');

        $this->layout = 'member_access';

        if ($this->Auth->user('id')) {
            return $this->redirect('/');
        }

        if ($this->request->is('post')) {
            if (isset_recaptcha() && !$this->Recaptcha->verify($this->request->data['g-recaptcha-response'])) {
                return $this->Flash->set($this->Recaptcha->error, array(
                        'element' => 'error'
                ));
                //return $this->redirect( array( 'action' => 'register' ) );
            }

            $this->request->data['User']['username'] = strtolower($this->request->data['User']['username']);
            $this->request->data['User']['register_ip'] = get_ip();
            $this->request->data['User']['account_type'] = 'Free';
            $this->request->data['User']['status'] = 'Inactive';
            $this->request->data['User']['redirection_type'] = 1;
            $this->request->data['User']['plan_id'] = Configure::read('Option.default_member_plan');
            $this->request->data['User']['timer'] = 5;
            $this->request->data['User']['user_activation_key'] = strtolower(Security::generateAuthKey());
            $this->request->data['User']['api_key'] = sha1(uniqid());

            $this->User->create();
            if ($this->User->save($this->request->data)) {
                $Email = new CakeEmail();
                $Email->template('register', 'app');
                $Email->viewVars(array(
                    'first_name' => $this->request->data['User']['first_name'],
                    'username' => $this->request->data['User']['username'],
                    'user_activation_key' => $this->request->data['User']['user_activation_key']
                ));
                $Email->from(Configure::read('Option.admin_email'));
                $Email->to($this->request->data['User']['email']);
                $Email->emailFormat('html');
                $Email->subject(Configure::read('Option.site_name') . ': New Account');
                $Email->send();


                $this->Flash->set(__('Kindly check your email for activation link.'), array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'login'));
            } else {
                $this->Flash->set(__('The user could not be saved. Please, try again.'), array(
                    'element' => 'error'
                ));
            }
        }
    }

    public function members_login()
    {
        $this->layout = 'member_access';

        $this->set('website_title', __('Member Login'));

        if ($this->request->is('post')) {
            if ($this->Auth->login()) {
                if ($this->Auth->user('status') != 'Active') {
                    $this->Flash->set(__('Your account has been deactivated.'), array(
                        'element' => 'error'
                    ));
                    return $this->redirect($this->Auth->logout());
                }

                $this->User->id = $this->Auth->user('id');

                $this->Session->write('last_login', $this->Auth->user('last_login'));

                $this->User->updateAll(array(
                    'User.user_activation_key' => '""',
                    'User.login_ip' => '"' . get_ip() . '"',
                    'User.last_login' => '"' . date("Y-m-d H:i:s") . '"'
                    ), array('User.id' => $this->User->id));
            } else {
                $this->Flash->set(__('Invalid username or password, try again'), array(
                    'element' => 'error'
                ));
            }
        }

        // Login redirect based on account type
        if ($this->Auth->user('account_type') == 'Free') {
            return $this->redirect(array('controller' => 'users', 'action' => 'dashboard', 'members' => 1));
        } elseif (in_array($this->Auth->user('account_type'), array('Admin', 'Demo'))) {
            return $this->redirect(array('controller' => 'users', 'action' => 'dashboard', 'admin' => 1));
        }
    }

    public function members_activate_account($username = null, $key = null)
    {
        $this->layout = 'member_access';

        if (!$username && !$key) {
            $this->Flash->set(__('Invalid Activation.'), array(
                'element' => 'error'
            ));
            return $this->redirect(array('action' => 'login'));
        }
        $user = $this->User->find('first', array(
            'conditions' => array(
                'User.status' => 'Inactive',
                'User.username' => $username,
                'User.user_activation_key' => $key
            ),
        ));
        if (!$user) {
            $this->Flash->set(__('Invalid Activation.'), array(
                'element' => 'error'
            ));
            return $this->redirect(array('action' => 'login'));
        }
        $data_activate = array(
            'id' => $user['User']['id'],
            'status' => 'Active',
            'user_activation_key' => ''
        );
        if ($this->User->save($data_activate)) {
            $this->Flash->set(__('Your account has been activated.'), array(
                'element' => 'success'
            ));
            return $this->redirect(array('action' => 'login'));
        } else {
            $this->Flash->set(__('Unable to activate your account.'), array(
                'element' => 'error'
            ));
            return $this->redirect(array('action' => 'login'));
        }
    }

    public function members_forgot_password($username = null, $key = null)
    {
        $this->layout = 'member_access';
        $this->set('website_title', 'Forgot Password');

        if ($this->request->is('post')) {
            if (isset_recaptcha() && !$this->Recaptcha->verify($this->request->data['g-recaptcha-response'])) {
                return $this->Flash->set($this->Recaptcha->error, array(
                        'element' => 'error'
                ));
                //return $this->redirect( array( 'action' => 'forgot_password' ) );
            }

            $email = $this->request->data['User']['email'];
            if (!$email && !Validation::email($email)) {
                $this->Flash->set(__('Please enter a valid email address.'), array(
                    'element' => 'error'
                ));
                return $this->redirect(array('action' => 'forgot_password'));
            }

            $user = $this->User->find('first', array(
                'conditions' => array(
                    'User.status' => 'Active',
                    'User.email' => $email
                ),
            ));

            if (!$user) {
                $this->Flash->set(__('Invalid User.'), array(
                    'element' => 'error'
                ));
                return $this->redirect(array('action' => 'forgot_password'));
            }

            if ($user['User']['account_type'] == 'Demo') {
                $this->Flash->set(__('This request is disabled into demo.'), array(
                    'element' => 'error'
                ));
                return $this->redirect($this->referer());
            }

            $reset_key = strtolower($this->User->Link->generateurl(40));

            $data_reset = array(
                'id' => $user['User']['id'],
                'user_activation_key' => $reset_key,
            );
            if ($this->User->save($data_reset)) {
                // Send rest email
                $Email = new CakeEmail();
                $Email->template('reset_password', 'app');
                $Email->viewVars(array(
                    'first_name' => $user['User']['first_name'],
                    'username' => $user['User']['username'],
                    'user_activation_key' => $reset_key
                ));
                $Email->from(Configure::read('Option.admin_email'));
                $Email->to($user['User']['email']);
                $Email->emailFormat('html');
                $Email->subject(Configure::read('Option.site_name') . ': Password Reset');
                $Email->send();

// Redirect to login page
                $this->Flash->set(__('Kindly check your email for reset password link.'), array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'login'));
            } else {
                $this->Flash->set(__('Unable to reset password.'), array(
                    'element' => 'error'
                ));
                return $this->redirect(array('action' => 'login'));
            }
        }
    }

    public function members_new_password($username = null, $key = null)
    {
        $this->layout = 'member_access';

        $this->set('website_title', 'New Password');

        if (!$username && !$key) {
            //throw new NotFoundException(__('Invalid Key.'));
            $this->Flash->set(__('Invalid Request.'), array(
                'element' => 'error'
            ));
            return $this->redirect(array('action' => 'login'));
        }
        $user = $this->User->find('first', array(
            'conditions' => array(
                'User.status' => 'Active',
                'User.username' => $username,
                'User.user_activation_key' => $key
            ),
        ));
        if (!$user) {
            //throw new NotFoundException(__('Invalid Key.'));
            $this->Flash->set(__('Invalid Request.'), array(
                'element' => 'error'
            ));
            return $this->redirect(array('action' => 'login'));
        }

//$this->set('user_id', $user['User']['id']);
//$this->set('key', $key);


        if ($this->request->is('post')) {
            $data_activate = array(
                'id' => $user['User']['id'],
                'password' => $this->request->data['User']['password'],
                'confirm_password' => $this->request->data['User']['confirm_password'],
                'user_activation_key' => ''
            );

//$this->request->data['User']['id'] = $user['User']['id'];
//$this->request->data['User']['user_activation_key'] = '';

            if ($this->User->save($data_activate)) {
                $this->Flash->set(__('Your password has been changed.'), array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'login'));
            } else {
                //debug($this->User->validationErrors);
                $this->Flash->set(__('Unable to change your password.'), array(
                    'element' => 'error'
                ));
//return $this->redirect(array('action' => 'new_password'));
            }
        }
    }

    public function members_logout()
    {
        $this->Session->delete('last_login');
        $this->Session->delete('PaginationOrder');
        return $this->redirect($this->Auth->logout());
    }

    public function admin_add()
    {
        $this->layout = 'admin';

        $this->set('website_title', __('Add a New User Account'));

        $plans = $this->User->Plan->find('list', array(
            'fields' => array('Plan.id', 'Plan.title'),
            'conditions' => array(
                'Plan.enable' => 1
            ),
            'order' => 'Plan.title ASC'
        ));
        $this->set('plans', $plans);

        if ($this->request->is('post')) {
            $this->request->data['User']['username'] = strtolower($this->request->data['User']['username']);
            $this->request->data['User']['register_ip'] = get_ip();
            $this->request->data['User']['redirection_type'] = 1;
            $this->request->data['User']['timer'] = 5;
            $this->request->data['User']['api_key'] = sha1(uniqid());
            $this->User->create();
            if ($this->User->save($this->request->data)) {
                $this->Flash->set(__('The account has been created.'), array(
                    'element' => 'success'
                ));
                $this->redirect(array('action' => 'index'));
            } else {
                $this->Flash->set(__('The user could not be saved. Please, try again.'), array(
                    'element' => 'error'
                ));
            }
        }
    }

    public function admin_edit($id = null)
    {
        $this->layout = 'admin';

        $this->set('website_title', 'Edit User Account');

        if (!$id) {
            throw new NotFoundException(__('Invalid User.'));
        }

        $user = $this->User->findById($id);
        if (!$user) {
            throw new NotFoundException(__('Invalid User.'));
        }
        $this->set('user', $user);

        $user_plan = $this->User->Plan->findById($user['User']['plan_id']);
        if (!$user_plan) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user_plan', $user_plan);

        $plans = $this->User->Plan->find('list', array(
            'fields' => array('Plan.id', 'Plan.title'),
            'conditions' => array(
                'Plan.enable' => 1
            ),
            'order' => 'Plan.title ASC'
        ));
        $this->set('plans', $plans);


        $validator = $this->User->validator();

        $validator['password']['minLength'] = array(
            'rule' => array('minLength', 6),
            'allowEmpty' => true,
            'message' => 'Passwords must be at least 6 characters long.'
        );

        $validator['confirm_password']['validatePasswordConfirm'] = array(
            'rule' => 'validatePasswordConfirm',
            'allowEmpty' => (!empty($this->request->data['User']['password'])) ? false : true,
            'message' => 'Passwords do not match'
        );

        if ($this->request->is(array('post', 'put'))) {
            $this->User->id = $id;
            if ($this->User->save($this->request->data)) {
                $this->Flash->set(__('The User has been updated'), array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'index'));
            } else {
                //debug($this->User->validationErrors);
                $this->Flash->set(__('The User could not be saved. Please, try again.'), array(
                    'element' => 'error'
                ));
            }
        } else {
            $this->request->data = $user;
            unset($this->request->data['User']['password']);
        }
    }

    public function members_edit()
    {
        $this->set('website_title', 'Member Edit');

        $id = $this->User->field('id', array('id' => $this->Auth->user('id')));

        if (!$id) {
            throw new NotFoundException(__('Invalid user.'));
        }

        if (!$this->User->isOwnedBy($id, $this->Auth->user('id'))) {
            throw new NotFoundException(__('Invalid User'));
        }

        if ($this->request->is(array('post', 'put'))) {
            $this->User->id = $id;
            if ($this->User->save($this->request->data)) {
                $this->Flash->set(__('The User has been saved'), array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'edit'));
            } else {
                //debug($this->User->validationErrors);
                $this->Flash->set(__('The User could not be saved. Please, try again.'), array(
                    'element' => 'error'
                ));
            }
        } else {
            $this->request->data = $this->User->read(null, $id);
            unset($this->request->data['User']['password']);
        }
    }

    public function members_settings()
    {
        $this->set('website_title', 'Member Settings');

        $id = $this->Auth->user('id');

        $user = $this->User->findById($this->Auth->user('id'));
        $this->set('user', $user);

        $user_plan = $this->User->Plan->findById($this->Auth->user('plan_id'));
        if (!$user_plan) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user_plan', $user_plan);

        $plans = $this->User->Plan->find('list', array(
            'fields' => array('Plan.id', 'Plan.title'),
            'conditions' => array(
                'Plan.enable' => 1
            ),
            'order' => 'Plan.title ASC'
        ));
        $this->set('plans', $plans);

        if ($this->request->is(array('post', 'put'))) {
            $this->User->id = $id;
            if ($this->User->save($this->request->data)) {
                $this->Flash->set('Your settings has been updated.', array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'settings'));
            } else {
                $this->Flash->set('Unable to update your settings.', array(
                    'element' => 'error'
                ));
            }
        } else {
            $this->request->data = $user;
        }
    }

    public function members_generate_api()
    {
        if (!$this->request->is('post')) {
            throw new MethodNotAllowedException();
        }

        $user = $this->User->find('first', array(
            'conditions' => array(
                'User.id' => $this->Auth->user('id')
            ),
        ));
        if (!$user) {
            throw new NotFoundException(__('Invalid User.'));
        }

        unset($user['User']['password']);
        $user['User']['api_key'] = sha1(md5(uniqid()));

        if ($this->User->save($user)) {
            $this->Flash->set(__('New API key has been generated.'), array(
                'element' => 'success'
            ));
            return $this->redirect(array('action' => 'settings'));
        } else {
            //debug( $this->User->validationErrors );
            $this->Flash->set(__('Can\'t generate API key'), array(
                'element' => 'error'
            ));
            return $this->redirect(array('action' => 'settings'));
        }
    }

    public function members_change_email($username = null, $key = null)
    {
        $this->set('website_title', 'Member Change Email');

        if (!$username && !$key) {
            $user = $this->User->findById($this->Auth->user('id'));
            $this->set('user', $user);

            if ($this->request->is(array('post', 'put'))) {
                $this->request->data['User']['id'] = $this->Auth->user('id');
                $this->request->data['User']['change_email_key'] = sha1(uniqid());
                $this->request->data['User']['temp_email'] = $this->request->data['User']['email'];

                if ($this->User->save($this->request->data)) {
                    // Send rest email
                    $Email = new CakeEmail();
                    $Email->template('change_email', 'app');
                    $Email->viewVars(array(
                        'first_name' => $this->Auth->user('first_name'),
                        'username' => $this->Auth->user('username'),
                        'change_email_key' => $this->request->data['User']['change_email_key']
                    ));
                    $Email->from(Configure::read('Option.admin_email'));
                    $Email->to($this->request->data['User']['temp_email']);
                    $Email->emailFormat('html');
                    $Email->subject(Configure::read('Option.site_name') . ': Change Email');
                    $Email->send();

                    $this->Flash->set('Kindly check your email to confirm it.', array(
                        'element' => 'success'
                    ));
                    return $this->redirect(array('action' => 'edit'));
                } else {
                    $this->Flash->set('Unable to update your email.', array(
                        'element' => 'error'
                    ));
                }
            }
        } else {
            $user = $this->User->find('first', array(
                'conditions' => array(
                    'User.username' => $username,
                    'User.change_email_key' => $key
                )
            ));
            if (!$user) {
                $this->Flash->set(__('Invalid Activation.'), array(
                    'element' => 'error'
                ));
                return $this->redirect(array('action' => 'login'));
            }
            $data_activate = array(
                'id' => $user['User']['id'],
                'email' => $user['User']['temp_email'],
                'temp_email' => '',
                'change_email_key' => ''
            );
            if ($this->User->save($data_activate)) {
                $this->Flash->set(__('Your email has been confirmed.'), array(
                    'element' => 'success'
                ));

                $this->Session->delete('last_login');
                $this->Session->delete('PaginationOrder');
                $this->Auth->logout();
                return $this->redirect(array('action' => 'login'));
            } else {
                $this->Flash->set(__('Unable to confirm your email.'), array(
                    'element' => 'error'
                ));
                return $this->redirect(array('action' => 'change_email'));
            }
        }
    }

    public function members_change_password()
    {
        $this->set('website_title', 'Member Change Password');

        if ($this->request->is(array('post', 'put'))) {
            $this->request->data['User']['id'] = $this->Auth->user('id');

            if ($this->User->save($this->request->data)) {
                $this->Flash->set(__('Password has been updated'), array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'change_password'));
            } else {
                //debug( $this->User->validationErrors );
                $this->Flash->set(__('Password could not be updated. Please, try again.'), array(
                    'element' => 'error'
                ));
            }
        }
    }

    public function admin_delete($id = null)
    {
        if (!$id) {
            throw new NotFoundException(__('Invalid User.'));
        }

        if (in_array($id, array(1))) {
            $this->Flash->set(__('You can\'t delete this USER.'), array(
                'element' => 'error'
            ));
            return $this->redirect(array('action' => 'index'));
        }

        if (!$this->request->is('post')) {
            throw new MethodNotAllowedException();
        }

        $user = $this->User->find('first', array(
            'conditions' => array(
                'User.id' => $id
            ),
        ));
        if (!$user) {
            throw new NotFoundException(__('Invalid User.'));
        }

        $this->User->id = $id;

        if ($this->User->delete()) {
            $this->Flash->set(__('User has been deleted'), array(
                'element' => 'success'
            ));
            return $this->redirect(array('action' => 'index'));
        } else {
            $this->Flash->set(__('User was not deleted'), array(
                'element' => 'error'
            ));
            return $this->redirect(array('action' => 'index'));
        }
    }
}
